from __future__ import generators
import plus
import AI
from AI import vector3
import Arenas
import Gooey
import math
import Tactics

class LittleMetalFriend(AI.SuperAI):
    "Pushes and grabs!"
    name = "LittleMetalFriend"

    def __init__(self, **args):
        AI.SuperAI.__init__(self, **args)

	self.triggers = ["Srimech"]
        self.reloadTime = 0
        self.reloadDelay = 3

        self.spin_range = 3.0
        
        if 'range' in args:
            self.spin_range = args.get('range')

        if 'triggers' in args: self.triggers = args['triggers']
        if 'reload' in args: self.reloadDelay = args['reload']

        self.triggerIterator = iter(self.triggers)

        self.tactics.append(Tactics.Engage(self))

    def Activate(self, active):
        if active:
            if AI.SuperAI.debugging:
                self.debug = Gooey.Plain("watch", 0, 75, 100, 75)
                tbox = self.debug.addText("line0", 0, 0, 100, 15)
                tbox.setText("Throttle")
                tbox = self.debug.addText("line1", 0, 15, 100, 15)
                tbox.setText("Turning")
                tbox = self.debug.addText("line2", 0, 30, 100, 15)
                tbox.setText("")
                tbox = self.debug.addText("line3", 0, 45, 100, 15)
                tbox.setText("")
            
            self.RegisterSmartZone("squeeze", 1)
            
        return AI.SuperAI.Activate(self, active)

    def Tick(self):
        if self.weapons:
            # spin up depending on enemy's range
            enemy, range = self.GetNearestEnemy()
            
            if enemy is not None and range < self.spin_range:
                self.Input("Spin", 0, 1)
            elif self.GetInputStatus("Spin", 0) != 0:
                self.Input("Spin", 0, 0)

        targets = [x for x in self.sensors.itervalues() if x.contacts > 0]
        if len(targets) > 0:
            # TODO: squeeze and push? or whip?
            self.Input("Lefthook", 0, -100)
            self.Input("Righthook", 0, -100)
        else:
            # TODO: open arms back up?
            self.Input("Lefthook", 0, 100)
            self.Input("Righthook", 0, 100)
            
        return AI.SuperAI.Tick(self)

    def InvertHandler(self):
        # fire all weapons once per second (until we're upright!)
        while 1:
            for trigger in self.triggers:
                self.Input(trigger, 0, 1)
            
            for i in range(0, 8):
                yield 0

    def DebugString(self, id, string):
        if self.debug:
            if id == 0: self.debug.get("line0").setText(string)
            elif id == 1: self.debug.get("line1").setText(string)
            elif id == 2: self.debug.get("line2").setText(string)
            elif id == 3: self.debug.get("line3").setText(string)
        
AI.register(LittleMetalFriend)
